(function() {

	window.onload = function() {

		// Creating a new map
		var map = new google.maps.Map(document.getElementById("map-canvas"), {
           center: new google.maps.LatLng(25.2802274,51.2543003,),
      styles: [{"featureType":"administrative","elementType":"labels.text.fill","stylers":[{"color":"#444444"}]},{"featureType":"landscape","elementType":"all","stylers":[{"color":"#f2f2f2"}]},{"featureType":"poi","elementType":"all","stylers":[{"visibility":"off"}]},{"featureType":"road","elementType":"all","stylers":[{"saturation":-100},{"lightness":45}]},{"featureType":"road.highway","elementType":"all","stylers":[{"visibility":"simplified"}]},{"featureType":"road.arterial","elementType":"labels.icon","stylers":[{"visibility":"off"}]},{"featureType":"transit","elementType":"all","stylers":[{"visibility":"off"}]},{"featureType":"water","elementType":"all","stylers":[{"color":"#b5b5b5"},{"visibility":"on"}]}],
             
          zoom: 8,
            
          mapTypeId: google.maps.MapTypeId.ROADMAP
        });
   
		// Creating the JSON data
		var json = [
		      
                {
		         "id": 2,
        "name": "Expert.",
        "address": "Doha Qatar",
        "workingDays": "",
        "businessHours": "",
        "latitude": "25.2802274",
        "longitude": "51.2543003",
        "lang": "ENGLISH"
    
   
    }];

		

		// Creating a global infoWindow object that will be reused by all markers
		var infoWindow = new google.maps.InfoWindow();

		// Looping through the JSON data
		for (var i = 0, length = json.length; i < length; i++) {
			var data = json[i],
				latLng = new google.maps.LatLng(data.latitude, data.longitude);

			// Creating a marker and putting it on the map
			 var marker = new google.maps.Marker({
      position: new google.maps.LatLng(data.latitude,data.longitude),
      map: map,
        animation: google.maps.Animation.DROP,
        icon: '', // null = default icon
      title:data.name,// this works, giving the marker a title with the correct title
     
       
    });


			// Creating a closure to retain the correct data, notice how I pass the current data in the loop into the closure (marker, data)
			(function(marker, data) {

				// Attaching a click event to the current marker
				google.maps.event.addListener(marker, "click", function(e) {
					infoWindow.setContent("<h1>"+data.name+"</h1>"+ "<br>"+data.address);
					infoWindow.open(map, marker);
				});


			})(marker, data);

		}

	}

})();